#include <iostream>
#include <vector>
using namespace std;

int partition(int low, int high, vector<int>&a, vector<double>&p) {
    int pivot = p[high];
    int i = (low - 1);
    for (int j = low; j <= high - 1; j++) {
        if (p[j] <= pivot) {
            i++;
            swap(p[i], p[j]);
            swap(a[i], a[j]);
        }
    }
    swap(p[i + 1], p[high]);
    swap(a[i + 1], a[high]);
    return (i + 1);
}

void quickSort(int low, int high, vector<int>&a, vector<double>&p) {
    if (low < high) {
        int pi = partition(low, high, a, p);
        quickSort(low, pi - 1, a, p);
        quickSort(pi + 1, high, a, p);
    }
}
int main() {
    int n;
    cin >> n;
    vector<int>a(n);
    vector<double>p(n);
    long double k = 0, kmax = 0;
    for (int i = 0; i < n; i++) {
        cin >> a[i] >> p[i];
    }
    quickSort(0, n - 1, a, p);
    for (int i = n - 1; i > 0; i--) {
        k += a[i];
        if (k* p[i] / 100 > kmax) kmax = (k * p[i] / 100);
    }
    printf("%.4f", kmax);
	return 0;
}